/*
 * Copyright 2025 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
 
/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

#ifndef _CLOCK_CONFIG_H_
#define _CLOCK_CONFIG_H_

#include "fsl_common.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*******************************************************************************
 ************************ BOARD_InitBootClocks function ************************
 ******************************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus*/

/*!
 * @brief This function executes default configuration of clocks.
 *
 */
void BOARD_InitBootClocks(void);

#if defined(__cplusplus)
}
#endif /* __cplusplus*/

/*******************************************************************************
 ******************** Configuration BOARD_BootClockFRO12M **********************
 ******************************************************************************/
/*******************************************************************************
 * Definitions for BOARD_BootClockFRO12M configuration
 ******************************************************************************/
#define BOARD_BOOTCLOCKFRO12M_CORE_CLOCK           12000000U  /*!< Core clock frequency: 12000000Hz */

/* Clock outputs (values are in Hz): */
#define BOARD_BOOTCLOCKFRO12M_ADC_CLOCK               0UL            /* Clock consumers of ADC_clock output : ADC0, ADC1, ADC2, ADC3 */
#define BOARD_BOOTCLOCKFRO12M_BUS_CLOCK               6000000UL      /* Clock consumers of BUS_clock output : OPAMP0, OPAMP1, OPAMP2, OPAMP3 */
#define BOARD_BOOTCLOCKFRO12M_CLK16K_0_CLOCK          0UL            /* Clock consumers of CLK16K_0_clock output : CMP0, LPTMR0, RTC0, WAKETIMER0 */
#define BOARD_BOOTCLOCKFRO12M_CLK16K_1_CLOCK          0UL            /* Clock consumers of CLK16K_1_clock output : CMP1, CMP2, SLCD0, WAKETIMER0 */
#define BOARD_BOOTCLOCKFRO12M_CLKOUT_CLOCK            0UL            /* Clock consumers of CLKOUT_clock output : N/A */
#define BOARD_BOOTCLOCKFRO12M_CLK_1M_CLOCK            1000000UL      /* Clock consumers of CLK_1M_clock output : CMC */
#define BOARD_BOOTCLOCKFRO12M_CLK_45M_CLOCK           45000000UL     /* Clock consumers of CLK_45M_clock output : N/A */
#define BOARD_BOOTCLOCKFRO12M_CLK_IN_CLOCK            0UL            /* Clock consumers of CLK_IN_clock output : N/A */
#define BOARD_BOOTCLOCKFRO12M_CMP0_FUNC_DIV_CLOCK     0UL            /* Clock consumers of CMP0_FUNC_DIV_clock output : CMP0 */
#define BOARD_BOOTCLOCKFRO12M_CMP0_RR_DIV_CLOCK       0UL            /* Clock consumers of CMP0_RR_DIV_clock output : CMP0 */
#define BOARD_BOOTCLOCKFRO12M_CMP1_FUNC_DIV_CLOCK     0UL            /* Clock consumers of CMP1_FUNC_DIV_clock output : CMP1 */
#define BOARD_BOOTCLOCKFRO12M_CMP1_RR_DIV_CLOCK       0UL            /* Clock consumers of CMP1_RR_DIV_clock output : CMP1 */
#define BOARD_BOOTCLOCKFRO12M_CMP2_FUNC_DIV_CLOCK     0UL            /* Clock consumers of CMP2_FUNC_DIV_clock output : CMP2 */
#define BOARD_BOOTCLOCKFRO12M_CMP2_RR_DIV_CLOCK       0UL            /* Clock consumers of CMP2_RR_DIV_clock output : CMP2 */
#define BOARD_BOOTCLOCKFRO12M_CPU_CLOCK               12000000UL     /* Clock consumers of CPU_clock output : N/A */
#define BOARD_BOOTCLOCKFRO12M_CTIMER0_CLOCK           0UL            /* Clock consumers of CTIMER0_clock output : CTIMER0 */
#define BOARD_BOOTCLOCKFRO12M_CTIMER1_CLOCK           0UL            /* Clock consumers of CTIMER1_clock output : CTIMER1 */
#define BOARD_BOOTCLOCKFRO12M_CTIMER2_CLOCK           0UL            /* Clock consumers of CTIMER2_clock output : CTIMER2 */
#define BOARD_BOOTCLOCKFRO12M_CTIMER3_CLOCK           0UL            /* Clock consumers of CTIMER3_clock output : CTIMER3 */
#define BOARD_BOOTCLOCKFRO12M_CTIMER4_CLOCK           0UL            /* Clock consumers of CTIMER4_clock output : CTIMER4 */
#define BOARD_BOOTCLOCKFRO12M_DAC0_CLOCK              0UL            /* Clock consumers of DAC0_clock output : DAC0 */
#define BOARD_BOOTCLOCKFRO12M_FLEXCAN0_CLOCK          0UL            /* Clock consumers of FLEXCAN0_clock output : CAN0 */
#define BOARD_BOOTCLOCKFRO12M_FLEXCAN1_CLOCK          0UL            /* Clock consumers of FLEXCAN1_clock output : CAN1 */
#define BOARD_BOOTCLOCKFRO12M_FLEXIO0_CLOCK           0UL            /* Clock consumers of FLEXIO0_clock output : FLEXIO0 */
#define BOARD_BOOTCLOCKFRO12M_FREQME_REFERENCE_CLOCK  0UL            /* Clock consumers of FREQME_reference_clock output : N/A */
#define BOARD_BOOTCLOCKFRO12M_FREQME_TARGET_CLOCK     0UL            /* Clock consumers of FREQME_target_clock output : N/A */
#define BOARD_BOOTCLOCKFRO12M_FRO_12M_DIV_CLOCK       12000000UL     /* Clock consumers of FRO_12M_DIV_clock output : N/A */
#define BOARD_BOOTCLOCKFRO12M_FRO_12M_CLOCK           12000000UL     /* Clock consumers of FRO_12M_clock output : N/A */
#define BOARD_BOOTCLOCKFRO12M_FRO_HF_DIV_CLOCK        45000000UL     /* Clock consumers of FRO_HF_DIV_clock output : N/A */
#define BOARD_BOOTCLOCKFRO12M_FRO_HF_CLOCK            45000000UL     /* Clock consumers of FRO_HF_clock output : N/A */
#define BOARD_BOOTCLOCKFRO12M_I3C_FCLK_CLOCK          0UL            /* Clock consumers of I3C_FCLK_clock output : I3C0 */
#define BOARD_BOOTCLOCKFRO12M_I3C_SLOW_TC_CLOCK       0UL            /* Clock consumers of I3C_SLOW_TC_clock output : I3C0 */
#define BOARD_BOOTCLOCKFRO12M_I3C_SLOW_CLOCK          0UL            /* Clock consumers of I3C_SLOW_clock output : I3C0 */
#define BOARD_BOOTCLOCKFRO12M_LPI2C0_CLOCK            0UL            /* Clock consumers of LPI2C0_clock output : LPI2C0 */
#define BOARD_BOOTCLOCKFRO12M_LPI2C1_CLOCK            0UL            /* Clock consumers of LPI2C1_clock output : LPI2C1 */
#define BOARD_BOOTCLOCKFRO12M_LPI2C2_CLOCK            0UL            /* Clock consumers of LPI2C2_clock output : LPI2C2 */
#define BOARD_BOOTCLOCKFRO12M_LPI2C3_CLOCK            0UL            /* Clock consumers of LPI2C3_clock output : LPI2C3 */
#define BOARD_BOOTCLOCKFRO12M_LPSPI0_CLOCK            0UL            /* Clock consumers of LPSPI0_clock output : LPSPI0 */
#define BOARD_BOOTCLOCKFRO12M_LPSPI1_CLOCK            0UL            /* Clock consumers of LPSPI1_clock output : LPSPI1 */
#define BOARD_BOOTCLOCKFRO12M_LPTMR0_CLOCK            0UL            /* Clock consumers of LPTMR0_clock output : LPTMR0 */
#define BOARD_BOOTCLOCKFRO12M_LPUART0_CLOCK           0UL            /* Clock consumers of LPUART0_clock output : LPUART0 */
#define BOARD_BOOTCLOCKFRO12M_LPUART1_CLOCK           0UL            /* Clock consumers of LPUART1_clock output : LPUART1 */
#define BOARD_BOOTCLOCKFRO12M_LPUART2_CLOCK           0UL            /* Clock consumers of LPUART2_clock output : LPUART2 */
#define BOARD_BOOTCLOCKFRO12M_LPUART3_CLOCK           0UL            /* Clock consumers of LPUART3_clock output : LPUART3 */
#define BOARD_BOOTCLOCKFRO12M_LPUART4_CLOCK           0UL            /* Clock consumers of LPUART4_clock output : LPUART4 */
#define BOARD_BOOTCLOCKFRO12M_LPUART5_CLOCK           0UL            /* Clock consumers of LPUART5_clock output : LPUART5 */
#define BOARD_BOOTCLOCKFRO12M_MAIN_CLOCK              12000000UL     /* Clock consumers of MAIN_clock output : FLEXPWM0, FLEXPWM1 */
#define BOARD_BOOTCLOCKFRO12M_OSTIMER0_CLOCK          0UL            /* Clock consumers of OSTIMER0_clock output : OSTIMER0 */
#define BOARD_BOOTCLOCKFRO12M_PLL1_DIV_CLOCK          0UL            /* Clock consumers of PLL1_DIV_clock output : N/A */
#define BOARD_BOOTCLOCKFRO12M_PLL1_CLOCK              0UL            /* Clock consumers of PLL1_clock output : N/A */
#define BOARD_BOOTCLOCKFRO12M_SYSTICK_CLOCK           0UL            /* Clock consumers of SYSTICK_clock output : N/A */
#define BOARD_BOOTCLOCKFRO12M_SLOW_CLOCK              2000000UL      /* Clock consumers of Slow_clock output : AOI0, AOI1, CMC, LPTMR0, RTC0, SLCD0, WAKETIMER0 */
#define BOARD_BOOTCLOCKFRO12M_SYSTEM_CLOCK            12000000UL     /* Clock consumers of System_clock output : ADC0, ADC1, ADC2, ADC3, CAN0, CAN1, CMP0, CMP1, CMP2, CTIMER0, CTIMER1, CTIMER2, CTIMER3, CTIMER4, DAC0, DMA0, EQDC0, EQDC1, FLEXIO0, FLEXPWM0, FLEXPWM1, FREQME0, GPIO0, GPIO1, GPIO2, GPIO3, GPIO4, I3C0, LPI2C0, LPI2C1, LPI2C2, LPI2C3, LPSPI0, LPSPI1, LPUART0, LPUART1, LPUART2, LPUART3, LPUART4, LPUART5, OPAMP0, OPAMP1, OPAMP2, OPAMP3, OSTIMER0, PORT0, PORT1, PORT2, PORT3, PORT4, USB0, UTICK0, WWDT0 */
#define BOARD_BOOTCLOCKFRO12M_TRACE_CLOCK             12000000UL     /* Clock consumers of TRACE_clock output : N/A */
#define BOARD_BOOTCLOCKFRO12M_USB0_CLOCK              0UL            /* Clock consumers of USB0_clock output : USB0 */
#define BOARD_BOOTCLOCKFRO12M_UTICK0_CLOCK            1000000UL      /* Clock consumers of UTICK0_clock output : UTICK0 */
#define BOARD_BOOTCLOCKFRO12M_WWDT0_CLOCK             1000000UL      /* Clock consumers of WWDT0_clock output : WWDT0 */


/*******************************************************************************
 * API for BOARD_BootClockFRO12M configuration
 ******************************************************************************/
#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus*/

/*!
 * @brief This function executes configuration of clocks.
 *
 */
void BOARD_BootClockFRO12M(void);

#if defined(__cplusplus)
}
#endif /* __cplusplus*/

/*******************************************************************************
 ******************* Configuration BOARD_BootClockFROHF45M *********************
 ******************************************************************************/
/*******************************************************************************
 * Definitions for BOARD_BootClockFROHF45M configuration
 ******************************************************************************/
#define BOARD_BOOTCLOCKFROHF45M_CORE_CLOCK         45000000U  /*!< Core clock frequency: 45000000Hz */

/* Clock outputs (values are in Hz): */
#define BOARD_BOOTCLOCKFROHF45M_ADC_CLOCK             0UL            /* Clock consumers of ADC_clock output : ADC0, ADC1, ADC2, ADC3 */
#define BOARD_BOOTCLOCKFROHF45M_BUS_CLOCK             22500000UL     /* Clock consumers of BUS_clock output : OPAMP0, OPAMP1, OPAMP2, OPAMP3 */
#define BOARD_BOOTCLOCKFROHF45M_CLK16K_0_CLOCK        0UL            /* Clock consumers of CLK16K_0_clock output : CMP0, LPTMR0, RTC0, WAKETIMER0 */
#define BOARD_BOOTCLOCKFROHF45M_CLK16K_1_CLOCK        0UL            /* Clock consumers of CLK16K_1_clock output : CMP1, CMP2, SLCD0, WAKETIMER0 */
#define BOARD_BOOTCLOCKFROHF45M_CLKOUT_CLOCK          0UL            /* Clock consumers of CLKOUT_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF45M_CLK_1M_CLOCK          1000000UL      /* Clock consumers of CLK_1M_clock output : CMC */
#define BOARD_BOOTCLOCKFROHF45M_CLK_45M_CLOCK         45000000UL     /* Clock consumers of CLK_45M_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF45M_CLK_IN_CLOCK          0UL            /* Clock consumers of CLK_IN_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF45M_CMP0_FUNC_DIV_CLOCK   0UL            /* Clock consumers of CMP0_FUNC_DIV_clock output : CMP0 */
#define BOARD_BOOTCLOCKFROHF45M_CMP0_RR_DIV_CLOCK     0UL            /* Clock consumers of CMP0_RR_DIV_clock output : CMP0 */
#define BOARD_BOOTCLOCKFROHF45M_CMP1_FUNC_DIV_CLOCK   0UL            /* Clock consumers of CMP1_FUNC_DIV_clock output : CMP1 */
#define BOARD_BOOTCLOCKFROHF45M_CMP1_RR_DIV_CLOCK     0UL            /* Clock consumers of CMP1_RR_DIV_clock output : CMP1 */
#define BOARD_BOOTCLOCKFROHF45M_CMP2_FUNC_DIV_CLOCK   0UL            /* Clock consumers of CMP2_FUNC_DIV_clock output : CMP2 */
#define BOARD_BOOTCLOCKFROHF45M_CMP2_RR_DIV_CLOCK     0UL            /* Clock consumers of CMP2_RR_DIV_clock output : CMP2 */
#define BOARD_BOOTCLOCKFROHF45M_CPU_CLOCK             45000000UL     /* Clock consumers of CPU_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF45M_CTIMER0_CLOCK         0UL            /* Clock consumers of CTIMER0_clock output : CTIMER0 */
#define BOARD_BOOTCLOCKFROHF45M_CTIMER1_CLOCK         0UL            /* Clock consumers of CTIMER1_clock output : CTIMER1 */
#define BOARD_BOOTCLOCKFROHF45M_CTIMER2_CLOCK         0UL            /* Clock consumers of CTIMER2_clock output : CTIMER2 */
#define BOARD_BOOTCLOCKFROHF45M_CTIMER3_CLOCK         0UL            /* Clock consumers of CTIMER3_clock output : CTIMER3 */
#define BOARD_BOOTCLOCKFROHF45M_CTIMER4_CLOCK         0UL            /* Clock consumers of CTIMER4_clock output : CTIMER4 */
#define BOARD_BOOTCLOCKFROHF45M_DAC0_CLOCK            0UL            /* Clock consumers of DAC0_clock output : DAC0 */
#define BOARD_BOOTCLOCKFROHF45M_FLEXCAN0_CLOCK        0UL            /* Clock consumers of FLEXCAN0_clock output : CAN0 */
#define BOARD_BOOTCLOCKFROHF45M_FLEXCAN1_CLOCK        0UL            /* Clock consumers of FLEXCAN1_clock output : CAN1 */
#define BOARD_BOOTCLOCKFROHF45M_FLEXIO0_CLOCK         0UL            /* Clock consumers of FLEXIO0_clock output : FLEXIO0 */
#define BOARD_BOOTCLOCKFROHF45M_FREQME_REFERENCE_CLOCK 0UL           /* Clock consumers of FREQME_reference_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF45M_FREQME_TARGET_CLOCK   0UL            /* Clock consumers of FREQME_target_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF45M_FRO_12M_DIV_CLOCK     12000000UL     /* Clock consumers of FRO_12M_DIV_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF45M_FRO_12M_CLOCK         12000000UL     /* Clock consumers of FRO_12M_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF45M_FRO_HF_DIV_CLOCK      45000000UL     /* Clock consumers of FRO_HF_DIV_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF45M_FRO_HF_CLOCK          45000000UL     /* Clock consumers of FRO_HF_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF45M_I3C_FCLK_CLOCK        0UL            /* Clock consumers of I3C_FCLK_clock output : I3C0 */
#define BOARD_BOOTCLOCKFROHF45M_I3C_SLOW_TC_CLOCK     0UL            /* Clock consumers of I3C_SLOW_TC_clock output : I3C0 */
#define BOARD_BOOTCLOCKFROHF45M_I3C_SLOW_CLOCK        0UL            /* Clock consumers of I3C_SLOW_clock output : I3C0 */
#define BOARD_BOOTCLOCKFROHF45M_LPI2C0_CLOCK          0UL            /* Clock consumers of LPI2C0_clock output : LPI2C0 */
#define BOARD_BOOTCLOCKFROHF45M_LPI2C1_CLOCK          0UL            /* Clock consumers of LPI2C1_clock output : LPI2C1 */
#define BOARD_BOOTCLOCKFROHF45M_LPI2C2_CLOCK          0UL            /* Clock consumers of LPI2C2_clock output : LPI2C2 */
#define BOARD_BOOTCLOCKFROHF45M_LPI2C3_CLOCK          0UL            /* Clock consumers of LPI2C3_clock output : LPI2C3 */
#define BOARD_BOOTCLOCKFROHF45M_LPSPI0_CLOCK          0UL            /* Clock consumers of LPSPI0_clock output : LPSPI0 */
#define BOARD_BOOTCLOCKFROHF45M_LPSPI1_CLOCK          0UL            /* Clock consumers of LPSPI1_clock output : LPSPI1 */
#define BOARD_BOOTCLOCKFROHF45M_LPTMR0_CLOCK          0UL            /* Clock consumers of LPTMR0_clock output : LPTMR0 */
#define BOARD_BOOTCLOCKFROHF45M_LPUART0_CLOCK         0UL            /* Clock consumers of LPUART0_clock output : LPUART0 */
#define BOARD_BOOTCLOCKFROHF45M_LPUART1_CLOCK         0UL            /* Clock consumers of LPUART1_clock output : LPUART1 */
#define BOARD_BOOTCLOCKFROHF45M_LPUART2_CLOCK         0UL            /* Clock consumers of LPUART2_clock output : LPUART2 */
#define BOARD_BOOTCLOCKFROHF45M_LPUART3_CLOCK         0UL            /* Clock consumers of LPUART3_clock output : LPUART3 */
#define BOARD_BOOTCLOCKFROHF45M_LPUART4_CLOCK         0UL            /* Clock consumers of LPUART4_clock output : LPUART4 */
#define BOARD_BOOTCLOCKFROHF45M_LPUART5_CLOCK         0UL            /* Clock consumers of LPUART5_clock output : LPUART5 */
#define BOARD_BOOTCLOCKFROHF45M_MAIN_CLOCK            45000000UL     /* Clock consumers of MAIN_clock output : FLEXPWM0, FLEXPWM1 */
#define BOARD_BOOTCLOCKFROHF45M_OSTIMER0_CLOCK        0UL            /* Clock consumers of OSTIMER0_clock output : OSTIMER0 */
#define BOARD_BOOTCLOCKFROHF45M_PLL1_DIV_CLOCK        0UL            /* Clock consumers of PLL1_DIV_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF45M_PLL1_CLOCK            0UL            /* Clock consumers of PLL1_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF45M_SYSTICK_CLOCK         0UL            /* Clock consumers of SYSTICK_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF45M_SLOW_CLOCK            7500000UL      /* Clock consumers of Slow_clock output : AOI0, AOI1, CMC, LPTMR0, RTC0, SLCD0, WAKETIMER0 */
#define BOARD_BOOTCLOCKFROHF45M_SYSTEM_CLOCK          45000000UL     /* Clock consumers of System_clock output : ADC0, ADC1, ADC2, ADC3, CAN0, CAN1, CMP0, CMP1, CMP2, CTIMER0, CTIMER1, CTIMER2, CTIMER3, CTIMER4, DAC0, DMA0, EQDC0, EQDC1, FLEXIO0, FLEXPWM0, FLEXPWM1, FREQME0, GPIO0, GPIO1, GPIO2, GPIO3, GPIO4, I3C0, LPI2C0, LPI2C1, LPI2C2, LPI2C3, LPSPI0, LPSPI1, LPUART0, LPUART1, LPUART2, LPUART3, LPUART4, LPUART5, OPAMP0, OPAMP1, OPAMP2, OPAMP3, OSTIMER0, PORT0, PORT1, PORT2, PORT3, PORT4, USB0, UTICK0, WWDT0 */
#define BOARD_BOOTCLOCKFROHF45M_TRACE_CLOCK           45000000UL     /* Clock consumers of TRACE_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF45M_USB0_CLOCK            0UL            /* Clock consumers of USB0_clock output : USB0 */
#define BOARD_BOOTCLOCKFROHF45M_UTICK0_CLOCK          1000000UL      /* Clock consumers of UTICK0_clock output : UTICK0 */
#define BOARD_BOOTCLOCKFROHF45M_WWDT0_CLOCK           1000000UL      /* Clock consumers of WWDT0_clock output : WWDT0 */


/*******************************************************************************
 * API for BOARD_BootClockFROHF45M configuration
 ******************************************************************************/
#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus*/

/*!
 * @brief This function executes configuration of clocks.
 *
 */
void BOARD_BootClockFROHF45M(void);

#if defined(__cplusplus)
}
#endif /* __cplusplus*/

/*******************************************************************************
 ******************* Configuration BOARD_BootClockFROHF60M *********************
 ******************************************************************************/
/*******************************************************************************
 * Definitions for BOARD_BootClockFROHF60M configuration
 ******************************************************************************/
#define BOARD_BOOTCLOCKFROHF60M_CORE_CLOCK         60000000U  /*!< Core clock frequency: 60000000Hz */

/* Clock outputs (values are in Hz): */
#define BOARD_BOOTCLOCKFROHF60M_ADC_CLOCK             0UL            /* Clock consumers of ADC_clock output : ADC0, ADC1, ADC2, ADC3 */
#define BOARD_BOOTCLOCKFROHF60M_BUS_CLOCK             30000000UL     /* Clock consumers of BUS_clock output : OPAMP0, OPAMP1, OPAMP2, OPAMP3 */
#define BOARD_BOOTCLOCKFROHF60M_CLK16K_0_CLOCK        0UL            /* Clock consumers of CLK16K_0_clock output : CMP0, LPTMR0, RTC0, WAKETIMER0 */
#define BOARD_BOOTCLOCKFROHF60M_CLK16K_1_CLOCK        0UL            /* Clock consumers of CLK16K_1_clock output : CMP1, CMP2, SLCD0, WAKETIMER0 */
#define BOARD_BOOTCLOCKFROHF60M_CLKOUT_CLOCK          0UL            /* Clock consumers of CLKOUT_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF60M_CLK_1M_CLOCK          1000000UL      /* Clock consumers of CLK_1M_clock output : CMC */
#define BOARD_BOOTCLOCKFROHF60M_CLK_45M_CLOCK         45000000UL     /* Clock consumers of CLK_45M_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF60M_CLK_IN_CLOCK          0UL            /* Clock consumers of CLK_IN_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF60M_CMP0_FUNC_DIV_CLOCK   0UL            /* Clock consumers of CMP0_FUNC_DIV_clock output : CMP0 */
#define BOARD_BOOTCLOCKFROHF60M_CMP0_RR_DIV_CLOCK     0UL            /* Clock consumers of CMP0_RR_DIV_clock output : CMP0 */
#define BOARD_BOOTCLOCKFROHF60M_CMP1_FUNC_DIV_CLOCK   0UL            /* Clock consumers of CMP1_FUNC_DIV_clock output : CMP1 */
#define BOARD_BOOTCLOCKFROHF60M_CMP1_RR_DIV_CLOCK     0UL            /* Clock consumers of CMP1_RR_DIV_clock output : CMP1 */
#define BOARD_BOOTCLOCKFROHF60M_CMP2_FUNC_DIV_CLOCK   0UL            /* Clock consumers of CMP2_FUNC_DIV_clock output : CMP2 */
#define BOARD_BOOTCLOCKFROHF60M_CMP2_RR_DIV_CLOCK     0UL            /* Clock consumers of CMP2_RR_DIV_clock output : CMP2 */
#define BOARD_BOOTCLOCKFROHF60M_CPU_CLOCK             60000000UL     /* Clock consumers of CPU_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF60M_CTIMER0_CLOCK         0UL            /* Clock consumers of CTIMER0_clock output : CTIMER0 */
#define BOARD_BOOTCLOCKFROHF60M_CTIMER1_CLOCK         0UL            /* Clock consumers of CTIMER1_clock output : CTIMER1 */
#define BOARD_BOOTCLOCKFROHF60M_CTIMER2_CLOCK         0UL            /* Clock consumers of CTIMER2_clock output : CTIMER2 */
#define BOARD_BOOTCLOCKFROHF60M_CTIMER3_CLOCK         0UL            /* Clock consumers of CTIMER3_clock output : CTIMER3 */
#define BOARD_BOOTCLOCKFROHF60M_CTIMER4_CLOCK         0UL            /* Clock consumers of CTIMER4_clock output : CTIMER4 */
#define BOARD_BOOTCLOCKFROHF60M_DAC0_CLOCK            0UL            /* Clock consumers of DAC0_clock output : DAC0 */
#define BOARD_BOOTCLOCKFROHF60M_FLEXCAN0_CLOCK        0UL            /* Clock consumers of FLEXCAN0_clock output : CAN0 */
#define BOARD_BOOTCLOCKFROHF60M_FLEXCAN1_CLOCK        0UL            /* Clock consumers of FLEXCAN1_clock output : CAN1 */
#define BOARD_BOOTCLOCKFROHF60M_FLEXIO0_CLOCK         0UL            /* Clock consumers of FLEXIO0_clock output : FLEXIO0 */
#define BOARD_BOOTCLOCKFROHF60M_FREQME_REFERENCE_CLOCK 0UL           /* Clock consumers of FREQME_reference_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF60M_FREQME_TARGET_CLOCK   0UL            /* Clock consumers of FREQME_target_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF60M_FRO_12M_DIV_CLOCK     12000000UL     /* Clock consumers of FRO_12M_DIV_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF60M_FRO_12M_CLOCK         12000000UL     /* Clock consumers of FRO_12M_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF60M_FRO_HF_DIV_CLOCK      60000000UL     /* Clock consumers of FRO_HF_DIV_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF60M_FRO_HF_CLOCK          60000000UL     /* Clock consumers of FRO_HF_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF60M_I3C_FCLK_CLOCK        0UL            /* Clock consumers of I3C_FCLK_clock output : I3C0 */
#define BOARD_BOOTCLOCKFROHF60M_I3C_SLOW_TC_CLOCK     0UL            /* Clock consumers of I3C_SLOW_TC_clock output : I3C0 */
#define BOARD_BOOTCLOCKFROHF60M_I3C_SLOW_CLOCK        0UL            /* Clock consumers of I3C_SLOW_clock output : I3C0 */
#define BOARD_BOOTCLOCKFROHF60M_LPI2C0_CLOCK          0UL            /* Clock consumers of LPI2C0_clock output : LPI2C0 */
#define BOARD_BOOTCLOCKFROHF60M_LPI2C1_CLOCK          0UL            /* Clock consumers of LPI2C1_clock output : LPI2C1 */
#define BOARD_BOOTCLOCKFROHF60M_LPI2C2_CLOCK          0UL            /* Clock consumers of LPI2C2_clock output : LPI2C2 */
#define BOARD_BOOTCLOCKFROHF60M_LPI2C3_CLOCK          0UL            /* Clock consumers of LPI2C3_clock output : LPI2C3 */
#define BOARD_BOOTCLOCKFROHF60M_LPSPI0_CLOCK          0UL            /* Clock consumers of LPSPI0_clock output : LPSPI0 */
#define BOARD_BOOTCLOCKFROHF60M_LPSPI1_CLOCK          0UL            /* Clock consumers of LPSPI1_clock output : LPSPI1 */
#define BOARD_BOOTCLOCKFROHF60M_LPTMR0_CLOCK          0UL            /* Clock consumers of LPTMR0_clock output : LPTMR0 */
#define BOARD_BOOTCLOCKFROHF60M_LPUART0_CLOCK         0UL            /* Clock consumers of LPUART0_clock output : LPUART0 */
#define BOARD_BOOTCLOCKFROHF60M_LPUART1_CLOCK         0UL            /* Clock consumers of LPUART1_clock output : LPUART1 */
#define BOARD_BOOTCLOCKFROHF60M_LPUART2_CLOCK         0UL            /* Clock consumers of LPUART2_clock output : LPUART2 */
#define BOARD_BOOTCLOCKFROHF60M_LPUART3_CLOCK         0UL            /* Clock consumers of LPUART3_clock output : LPUART3 */
#define BOARD_BOOTCLOCKFROHF60M_LPUART4_CLOCK         0UL            /* Clock consumers of LPUART4_clock output : LPUART4 */
#define BOARD_BOOTCLOCKFROHF60M_LPUART5_CLOCK         0UL            /* Clock consumers of LPUART5_clock output : LPUART5 */
#define BOARD_BOOTCLOCKFROHF60M_MAIN_CLOCK            60000000UL     /* Clock consumers of MAIN_clock output : FLEXPWM0, FLEXPWM1 */
#define BOARD_BOOTCLOCKFROHF60M_OSTIMER0_CLOCK        0UL            /* Clock consumers of OSTIMER0_clock output : OSTIMER0 */
#define BOARD_BOOTCLOCKFROHF60M_PLL1_DIV_CLOCK        0UL            /* Clock consumers of PLL1_DIV_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF60M_PLL1_CLOCK            0UL            /* Clock consumers of PLL1_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF60M_SYSTICK_CLOCK         0UL            /* Clock consumers of SYSTICK_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF60M_SLOW_CLOCK            10000000UL     /* Clock consumers of Slow_clock output : AOI0, AOI1, CMC, LPTMR0, RTC0, SLCD0, WAKETIMER0 */
#define BOARD_BOOTCLOCKFROHF60M_SYSTEM_CLOCK          60000000UL     /* Clock consumers of System_clock output : ADC0, ADC1, ADC2, ADC3, CAN0, CAN1, CMP0, CMP1, CMP2, CTIMER0, CTIMER1, CTIMER2, CTIMER3, CTIMER4, DAC0, DMA0, EQDC0, EQDC1, FLEXIO0, FLEXPWM0, FLEXPWM1, FREQME0, GPIO0, GPIO1, GPIO2, GPIO3, GPIO4, I3C0, LPI2C0, LPI2C1, LPI2C2, LPI2C3, LPSPI0, LPSPI1, LPUART0, LPUART1, LPUART2, LPUART3, LPUART4, LPUART5, OPAMP0, OPAMP1, OPAMP2, OPAMP3, OSTIMER0, PORT0, PORT1, PORT2, PORT3, PORT4, USB0, UTICK0, WWDT0 */
#define BOARD_BOOTCLOCKFROHF60M_TRACE_CLOCK           60000000UL     /* Clock consumers of TRACE_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF60M_USB0_CLOCK            0UL            /* Clock consumers of USB0_clock output : USB0 */
#define BOARD_BOOTCLOCKFROHF60M_UTICK0_CLOCK          1000000UL      /* Clock consumers of UTICK0_clock output : UTICK0 */
#define BOARD_BOOTCLOCKFROHF60M_WWDT0_CLOCK           1000000UL      /* Clock consumers of WWDT0_clock output : WWDT0 */


/*******************************************************************************
 * API for BOARD_BootClockFROHF60M configuration
 ******************************************************************************/
#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus*/

/*!
 * @brief This function executes configuration of clocks.
 *
 */
void BOARD_BootClockFROHF60M(void);

#if defined(__cplusplus)
}
#endif /* __cplusplus*/

/*******************************************************************************
 ******************* Configuration BOARD_BootClockFROHF90M *********************
 ******************************************************************************/
/*******************************************************************************
 * Definitions for BOARD_BootClockFROHF90M configuration
 ******************************************************************************/
#define BOARD_BOOTCLOCKFROHF90M_CORE_CLOCK         90000000U  /*!< Core clock frequency: 90000000Hz */

/* Clock outputs (values are in Hz): */
#define BOARD_BOOTCLOCKFROHF90M_ADC_CLOCK             0UL            /* Clock consumers of ADC_clock output : ADC0, ADC1, ADC2, ADC3 */
#define BOARD_BOOTCLOCKFROHF90M_BUS_CLOCK             45000000UL     /* Clock consumers of BUS_clock output : OPAMP0, OPAMP1, OPAMP2, OPAMP3 */
#define BOARD_BOOTCLOCKFROHF90M_CLK16K_0_CLOCK        0UL            /* Clock consumers of CLK16K_0_clock output : CMP0, LPTMR0, RTC0, WAKETIMER0 */
#define BOARD_BOOTCLOCKFROHF90M_CLK16K_1_CLOCK        0UL            /* Clock consumers of CLK16K_1_clock output : CMP1, CMP2, SLCD0, WAKETIMER0 */
#define BOARD_BOOTCLOCKFROHF90M_CLKOUT_CLOCK          0UL            /* Clock consumers of CLKOUT_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF90M_CLK_1M_CLOCK          1000000UL      /* Clock consumers of CLK_1M_clock output : CMC */
#define BOARD_BOOTCLOCKFROHF90M_CLK_45M_CLOCK         45000000UL     /* Clock consumers of CLK_45M_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF90M_CLK_IN_CLOCK          0UL            /* Clock consumers of CLK_IN_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF90M_CMP0_FUNC_DIV_CLOCK   0UL            /* Clock consumers of CMP0_FUNC_DIV_clock output : CMP0 */
#define BOARD_BOOTCLOCKFROHF90M_CMP0_RR_DIV_CLOCK     0UL            /* Clock consumers of CMP0_RR_DIV_clock output : CMP0 */
#define BOARD_BOOTCLOCKFROHF90M_CMP1_FUNC_DIV_CLOCK   0UL            /* Clock consumers of CMP1_FUNC_DIV_clock output : CMP1 */
#define BOARD_BOOTCLOCKFROHF90M_CMP1_RR_DIV_CLOCK     0UL            /* Clock consumers of CMP1_RR_DIV_clock output : CMP1 */
#define BOARD_BOOTCLOCKFROHF90M_CMP2_FUNC_DIV_CLOCK   0UL            /* Clock consumers of CMP2_FUNC_DIV_clock output : CMP2 */
#define BOARD_BOOTCLOCKFROHF90M_CMP2_RR_DIV_CLOCK     0UL            /* Clock consumers of CMP2_RR_DIV_clock output : CMP2 */
#define BOARD_BOOTCLOCKFROHF90M_CPU_CLOCK             90000000UL     /* Clock consumers of CPU_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF90M_CTIMER0_CLOCK         0UL            /* Clock consumers of CTIMER0_clock output : CTIMER0 */
#define BOARD_BOOTCLOCKFROHF90M_CTIMER1_CLOCK         0UL            /* Clock consumers of CTIMER1_clock output : CTIMER1 */
#define BOARD_BOOTCLOCKFROHF90M_CTIMER2_CLOCK         0UL            /* Clock consumers of CTIMER2_clock output : CTIMER2 */
#define BOARD_BOOTCLOCKFROHF90M_CTIMER3_CLOCK         0UL            /* Clock consumers of CTIMER3_clock output : CTIMER3 */
#define BOARD_BOOTCLOCKFROHF90M_CTIMER4_CLOCK         0UL            /* Clock consumers of CTIMER4_clock output : CTIMER4 */
#define BOARD_BOOTCLOCKFROHF90M_DAC0_CLOCK            0UL            /* Clock consumers of DAC0_clock output : DAC0 */
#define BOARD_BOOTCLOCKFROHF90M_FLEXCAN0_CLOCK        0UL            /* Clock consumers of FLEXCAN0_clock output : CAN0 */
#define BOARD_BOOTCLOCKFROHF90M_FLEXCAN1_CLOCK        0UL            /* Clock consumers of FLEXCAN1_clock output : CAN1 */
#define BOARD_BOOTCLOCKFROHF90M_FLEXIO0_CLOCK         0UL            /* Clock consumers of FLEXIO0_clock output : FLEXIO0 */
#define BOARD_BOOTCLOCKFROHF90M_FREQME_REFERENCE_CLOCK 0UL           /* Clock consumers of FREQME_reference_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF90M_FREQME_TARGET_CLOCK   0UL            /* Clock consumers of FREQME_target_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF90M_FRO_12M_DIV_CLOCK     12000000UL     /* Clock consumers of FRO_12M_DIV_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF90M_FRO_12M_CLOCK         12000000UL     /* Clock consumers of FRO_12M_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF90M_FRO_HF_DIV_CLOCK      90000000UL     /* Clock consumers of FRO_HF_DIV_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF90M_FRO_HF_CLOCK          90000000UL     /* Clock consumers of FRO_HF_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF90M_I3C_FCLK_CLOCK        0UL            /* Clock consumers of I3C_FCLK_clock output : I3C0 */
#define BOARD_BOOTCLOCKFROHF90M_I3C_SLOW_TC_CLOCK     0UL            /* Clock consumers of I3C_SLOW_TC_clock output : I3C0 */
#define BOARD_BOOTCLOCKFROHF90M_I3C_SLOW_CLOCK        0UL            /* Clock consumers of I3C_SLOW_clock output : I3C0 */
#define BOARD_BOOTCLOCKFROHF90M_LPI2C0_CLOCK          0UL            /* Clock consumers of LPI2C0_clock output : LPI2C0 */
#define BOARD_BOOTCLOCKFROHF90M_LPI2C1_CLOCK          0UL            /* Clock consumers of LPI2C1_clock output : LPI2C1 */
#define BOARD_BOOTCLOCKFROHF90M_LPI2C2_CLOCK          0UL            /* Clock consumers of LPI2C2_clock output : LPI2C2 */
#define BOARD_BOOTCLOCKFROHF90M_LPI2C3_CLOCK          0UL            /* Clock consumers of LPI2C3_clock output : LPI2C3 */
#define BOARD_BOOTCLOCKFROHF90M_LPSPI0_CLOCK          0UL            /* Clock consumers of LPSPI0_clock output : LPSPI0 */
#define BOARD_BOOTCLOCKFROHF90M_LPSPI1_CLOCK          0UL            /* Clock consumers of LPSPI1_clock output : LPSPI1 */
#define BOARD_BOOTCLOCKFROHF90M_LPTMR0_CLOCK          0UL            /* Clock consumers of LPTMR0_clock output : LPTMR0 */
#define BOARD_BOOTCLOCKFROHF90M_LPUART0_CLOCK         0UL            /* Clock consumers of LPUART0_clock output : LPUART0 */
#define BOARD_BOOTCLOCKFROHF90M_LPUART1_CLOCK         0UL            /* Clock consumers of LPUART1_clock output : LPUART1 */
#define BOARD_BOOTCLOCKFROHF90M_LPUART2_CLOCK         0UL            /* Clock consumers of LPUART2_clock output : LPUART2 */
#define BOARD_BOOTCLOCKFROHF90M_LPUART3_CLOCK         0UL            /* Clock consumers of LPUART3_clock output : LPUART3 */
#define BOARD_BOOTCLOCKFROHF90M_LPUART4_CLOCK         0UL            /* Clock consumers of LPUART4_clock output : LPUART4 */
#define BOARD_BOOTCLOCKFROHF90M_LPUART5_CLOCK         0UL            /* Clock consumers of LPUART5_clock output : LPUART5 */
#define BOARD_BOOTCLOCKFROHF90M_MAIN_CLOCK            90000000UL     /* Clock consumers of MAIN_clock output : FLEXPWM0, FLEXPWM1 */
#define BOARD_BOOTCLOCKFROHF90M_OSTIMER0_CLOCK        0UL            /* Clock consumers of OSTIMER0_clock output : OSTIMER0 */
#define BOARD_BOOTCLOCKFROHF90M_PLL1_DIV_CLOCK        0UL            /* Clock consumers of PLL1_DIV_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF90M_PLL1_CLOCK            0UL            /* Clock consumers of PLL1_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF90M_SYSTICK_CLOCK         0UL            /* Clock consumers of SYSTICK_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF90M_SLOW_CLOCK            15000000UL     /* Clock consumers of Slow_clock output : AOI0, AOI1, CMC, LPTMR0, RTC0, SLCD0, WAKETIMER0 */
#define BOARD_BOOTCLOCKFROHF90M_SYSTEM_CLOCK          90000000UL     /* Clock consumers of System_clock output : ADC0, ADC1, ADC2, ADC3, CAN0, CAN1, CMP0, CMP1, CMP2, CTIMER0, CTIMER1, CTIMER2, CTIMER3, CTIMER4, DAC0, DMA0, EQDC0, EQDC1, FLEXIO0, FLEXPWM0, FLEXPWM1, FREQME0, GPIO0, GPIO1, GPIO2, GPIO3, GPIO4, I3C0, LPI2C0, LPI2C1, LPI2C2, LPI2C3, LPSPI0, LPSPI1, LPUART0, LPUART1, LPUART2, LPUART3, LPUART4, LPUART5, OPAMP0, OPAMP1, OPAMP2, OPAMP3, OSTIMER0, PORT0, PORT1, PORT2, PORT3, PORT4, USB0, UTICK0, WWDT0 */
#define BOARD_BOOTCLOCKFROHF90M_TRACE_CLOCK           90000000UL     /* Clock consumers of TRACE_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF90M_USB0_CLOCK            0UL            /* Clock consumers of USB0_clock output : USB0 */
#define BOARD_BOOTCLOCKFROHF90M_UTICK0_CLOCK          1000000UL      /* Clock consumers of UTICK0_clock output : UTICK0 */
#define BOARD_BOOTCLOCKFROHF90M_WWDT0_CLOCK           1000000UL      /* Clock consumers of WWDT0_clock output : WWDT0 */


/*******************************************************************************
 * API for BOARD_BootClockFROHF90M configuration
 ******************************************************************************/
#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus*/

/*!
 * @brief This function executes configuration of clocks.
 *
 */
void BOARD_BootClockFROHF90M(void);

#if defined(__cplusplus)
}
#endif /* __cplusplus*/

/*******************************************************************************
 ******************* Configuration BOARD_BootClockFROHF180M ********************
 ******************************************************************************/
/*******************************************************************************
 * Definitions for BOARD_BootClockFROHF180M configuration
 ******************************************************************************/
#define BOARD_BOOTCLOCKFROHF180M_CORE_CLOCK       180000000U  /*!< Core clock frequency: 180000000Hz */

/* Clock outputs (values are in Hz): */
#define BOARD_BOOTCLOCKFROHF180M_ADC_CLOCK            0UL            /* Clock consumers of ADC_clock output : ADC0, ADC1, ADC2, ADC3 */
#define BOARD_BOOTCLOCKFROHF180M_BUS_CLOCK            90000000UL     /* Clock consumers of BUS_clock output : OPAMP0, OPAMP1, OPAMP2, OPAMP3 */
#define BOARD_BOOTCLOCKFROHF180M_CLK16K_0_CLOCK       0UL            /* Clock consumers of CLK16K_0_clock output : CMP0, LPTMR0, RTC0, WAKETIMER0 */
#define BOARD_BOOTCLOCKFROHF180M_CLK16K_1_CLOCK       0UL            /* Clock consumers of CLK16K_1_clock output : CMP1, CMP2, SLCD0, WAKETIMER0 */
#define BOARD_BOOTCLOCKFROHF180M_CLKOUT_CLOCK         0UL            /* Clock consumers of CLKOUT_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF180M_CLK_1M_CLOCK         1000000UL      /* Clock consumers of CLK_1M_clock output : CMC */
#define BOARD_BOOTCLOCKFROHF180M_CLK_45M_CLOCK        45000000UL     /* Clock consumers of CLK_45M_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF180M_CLK_IN_CLOCK         0UL            /* Clock consumers of CLK_IN_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF180M_CMP0_FUNC_DIV_CLOCK  0UL            /* Clock consumers of CMP0_FUNC_DIV_clock output : CMP0 */
#define BOARD_BOOTCLOCKFROHF180M_CMP0_RR_DIV_CLOCK    0UL            /* Clock consumers of CMP0_RR_DIV_clock output : CMP0 */
#define BOARD_BOOTCLOCKFROHF180M_CMP1_FUNC_DIV_CLOCK  0UL            /* Clock consumers of CMP1_FUNC_DIV_clock output : CMP1 */
#define BOARD_BOOTCLOCKFROHF180M_CMP1_RR_DIV_CLOCK    0UL            /* Clock consumers of CMP1_RR_DIV_clock output : CMP1 */
#define BOARD_BOOTCLOCKFROHF180M_CMP2_FUNC_DIV_CLOCK  0UL            /* Clock consumers of CMP2_FUNC_DIV_clock output : CMP2 */
#define BOARD_BOOTCLOCKFROHF180M_CMP2_RR_DIV_CLOCK    0UL            /* Clock consumers of CMP2_RR_DIV_clock output : CMP2 */
#define BOARD_BOOTCLOCKFROHF180M_CPU_CLOCK            180000000UL    /* Clock consumers of CPU_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF180M_CTIMER0_CLOCK        0UL            /* Clock consumers of CTIMER0_clock output : CTIMER0 */
#define BOARD_BOOTCLOCKFROHF180M_CTIMER1_CLOCK        0UL            /* Clock consumers of CTIMER1_clock output : CTIMER1 */
#define BOARD_BOOTCLOCKFROHF180M_CTIMER2_CLOCK        0UL            /* Clock consumers of CTIMER2_clock output : CTIMER2 */
#define BOARD_BOOTCLOCKFROHF180M_CTIMER3_CLOCK        0UL            /* Clock consumers of CTIMER3_clock output : CTIMER3 */
#define BOARD_BOOTCLOCKFROHF180M_CTIMER4_CLOCK        0UL            /* Clock consumers of CTIMER4_clock output : CTIMER4 */
#define BOARD_BOOTCLOCKFROHF180M_DAC0_CLOCK           0UL            /* Clock consumers of DAC0_clock output : DAC0 */
#define BOARD_BOOTCLOCKFROHF180M_FLEXCAN0_CLOCK       0UL            /* Clock consumers of FLEXCAN0_clock output : CAN0 */
#define BOARD_BOOTCLOCKFROHF180M_FLEXCAN1_CLOCK       0UL            /* Clock consumers of FLEXCAN1_clock output : CAN1 */
#define BOARD_BOOTCLOCKFROHF180M_FLEXIO0_CLOCK        0UL            /* Clock consumers of FLEXIO0_clock output : FLEXIO0 */
#define BOARD_BOOTCLOCKFROHF180M_FREQME_REFERENCE_CLOCK 0UL          /* Clock consumers of FREQME_reference_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF180M_FREQME_TARGET_CLOCK  0UL            /* Clock consumers of FREQME_target_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF180M_FRO_12M_DIV_CLOCK    12000000UL     /* Clock consumers of FRO_12M_DIV_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF180M_FRO_12M_CLOCK        12000000UL     /* Clock consumers of FRO_12M_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF180M_FRO_HF_DIV_CLOCK     180000000UL    /* Clock consumers of FRO_HF_DIV_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF180M_FRO_HF_CLOCK         180000000UL    /* Clock consumers of FRO_HF_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF180M_I3C_FCLK_CLOCK       0UL            /* Clock consumers of I3C_FCLK_clock output : I3C0 */
#define BOARD_BOOTCLOCKFROHF180M_I3C_SLOW_TC_CLOCK    0UL            /* Clock consumers of I3C_SLOW_TC_clock output : I3C0 */
#define BOARD_BOOTCLOCKFROHF180M_I3C_SLOW_CLOCK       0UL            /* Clock consumers of I3C_SLOW_clock output : I3C0 */
#define BOARD_BOOTCLOCKFROHF180M_LPI2C0_CLOCK         0UL            /* Clock consumers of LPI2C0_clock output : LPI2C0 */
#define BOARD_BOOTCLOCKFROHF180M_LPI2C1_CLOCK         0UL            /* Clock consumers of LPI2C1_clock output : LPI2C1 */
#define BOARD_BOOTCLOCKFROHF180M_LPI2C2_CLOCK         0UL            /* Clock consumers of LPI2C2_clock output : LPI2C2 */
#define BOARD_BOOTCLOCKFROHF180M_LPI2C3_CLOCK         0UL            /* Clock consumers of LPI2C3_clock output : LPI2C3 */
#define BOARD_BOOTCLOCKFROHF180M_LPSPI0_CLOCK         0UL            /* Clock consumers of LPSPI0_clock output : LPSPI0 */
#define BOARD_BOOTCLOCKFROHF180M_LPSPI1_CLOCK         0UL            /* Clock consumers of LPSPI1_clock output : LPSPI1 */
#define BOARD_BOOTCLOCKFROHF180M_LPTMR0_CLOCK         0UL            /* Clock consumers of LPTMR0_clock output : LPTMR0 */
#define BOARD_BOOTCLOCKFROHF180M_LPUART0_CLOCK        0UL            /* Clock consumers of LPUART0_clock output : LPUART0 */
#define BOARD_BOOTCLOCKFROHF180M_LPUART1_CLOCK        0UL            /* Clock consumers of LPUART1_clock output : LPUART1 */
#define BOARD_BOOTCLOCKFROHF180M_LPUART2_CLOCK        0UL            /* Clock consumers of LPUART2_clock output : LPUART2 */
#define BOARD_BOOTCLOCKFROHF180M_LPUART3_CLOCK        0UL            /* Clock consumers of LPUART3_clock output : LPUART3 */
#define BOARD_BOOTCLOCKFROHF180M_LPUART4_CLOCK        0UL            /* Clock consumers of LPUART4_clock output : LPUART4 */
#define BOARD_BOOTCLOCKFROHF180M_LPUART5_CLOCK        0UL            /* Clock consumers of LPUART5_clock output : LPUART5 */
#define BOARD_BOOTCLOCKFROHF180M_MAIN_CLOCK           180000000UL    /* Clock consumers of MAIN_clock output : FLEXPWM0, FLEXPWM1 */
#define BOARD_BOOTCLOCKFROHF180M_OSTIMER0_CLOCK       0UL            /* Clock consumers of OSTIMER0_clock output : OSTIMER0 */
#define BOARD_BOOTCLOCKFROHF180M_PLL1_DIV_CLOCK       0UL            /* Clock consumers of PLL1_DIV_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF180M_PLL1_CLOCK           0UL            /* Clock consumers of PLL1_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF180M_SYSTICK_CLOCK        0UL            /* Clock consumers of SYSTICK_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF180M_SLOW_CLOCK           30000000UL     /* Clock consumers of Slow_clock output : AOI0, AOI1, CMC, LPTMR0, RTC0, SLCD0, WAKETIMER0 */
#define BOARD_BOOTCLOCKFROHF180M_SYSTEM_CLOCK         180000000UL    /* Clock consumers of System_clock output : ADC0, ADC1, ADC2, ADC3, CAN0, CAN1, CMP0, CMP1, CMP2, CTIMER0, CTIMER1, CTIMER2, CTIMER3, CTIMER4, DAC0, DMA0, EQDC0, EQDC1, FLEXIO0, FLEXPWM0, FLEXPWM1, FREQME0, GPIO0, GPIO1, GPIO2, GPIO3, GPIO4, I3C0, LPI2C0, LPI2C1, LPI2C2, LPI2C3, LPSPI0, LPSPI1, LPUART0, LPUART1, LPUART2, LPUART3, LPUART4, LPUART5, OPAMP0, OPAMP1, OPAMP2, OPAMP3, OSTIMER0, PORT0, PORT1, PORT2, PORT3, PORT4, USB0, UTICK0, WWDT0 */
#define BOARD_BOOTCLOCKFROHF180M_TRACE_CLOCK          90000000UL     /* Clock consumers of TRACE_clock output : N/A */
#define BOARD_BOOTCLOCKFROHF180M_USB0_CLOCK           0UL            /* Clock consumers of USB0_clock output : USB0 */
#define BOARD_BOOTCLOCKFROHF180M_UTICK0_CLOCK         1000000UL      /* Clock consumers of UTICK0_clock output : UTICK0 */
#define BOARD_BOOTCLOCKFROHF180M_WWDT0_CLOCK          1000000UL      /* Clock consumers of WWDT0_clock output : WWDT0 */


/*******************************************************************************
 * API for BOARD_BootClockFROHF180M configuration
 ******************************************************************************/
#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus*/

/*!
 * @brief This function executes configuration of clocks.
 *
 */
void BOARD_BootClockFROHF180M(void);

#if defined(__cplusplus)
}
#endif /* __cplusplus*/

/*******************************************************************************
 ******************** Configuration BOARD_BootClockPLL180M *********************
 ******************************************************************************/
/*******************************************************************************
 * Definitions for BOARD_BootClockPLL180M configuration
 ******************************************************************************/
#define BOARD_BOOTCLOCKPLL180M_CORE_CLOCK         180000000U  /*!< Core clock frequency: 180000000Hz */

/* Clock outputs (values are in Hz): */
#define BOARD_BOOTCLOCKPLL180M_ADC_CLOCK              0UL            /* Clock consumers of ADC_clock output : ADC0, ADC1, ADC2, ADC3 */
#define BOARD_BOOTCLOCKPLL180M_BUS_CLOCK              90000000UL     /* Clock consumers of BUS_clock output : OPAMP0, OPAMP1, OPAMP2, OPAMP3 */
#define BOARD_BOOTCLOCKPLL180M_CLK16K_0_CLOCK         0UL            /* Clock consumers of CLK16K_0_clock output : CMP0, LPTMR0, RTC0, WAKETIMER0 */
#define BOARD_BOOTCLOCKPLL180M_CLK16K_1_CLOCK         0UL            /* Clock consumers of CLK16K_1_clock output : CMP1, CMP2, SLCD0, WAKETIMER0 */
#define BOARD_BOOTCLOCKPLL180M_CLKOUT_CLOCK           0UL            /* Clock consumers of CLKOUT_clock output : N/A */
#define BOARD_BOOTCLOCKPLL180M_CLK_1M_CLOCK           1000000UL      /* Clock consumers of CLK_1M_clock output : CMC */
#define BOARD_BOOTCLOCKPLL180M_CLK_45M_CLOCK          45000000UL     /* Clock consumers of CLK_45M_clock output : N/A */
#define BOARD_BOOTCLOCKPLL180M_CLK_IN_CLOCK           0UL            /* Clock consumers of CLK_IN_clock output : N/A */
#define BOARD_BOOTCLOCKPLL180M_CMP0_FUNC_DIV_CLOCK    0UL            /* Clock consumers of CMP0_FUNC_DIV_clock output : CMP0 */
#define BOARD_BOOTCLOCKPLL180M_CMP0_RR_DIV_CLOCK      0UL            /* Clock consumers of CMP0_RR_DIV_clock output : CMP0 */
#define BOARD_BOOTCLOCKPLL180M_CMP1_FUNC_DIV_CLOCK    0UL            /* Clock consumers of CMP1_FUNC_DIV_clock output : CMP1 */
#define BOARD_BOOTCLOCKPLL180M_CMP1_RR_DIV_CLOCK      0UL            /* Clock consumers of CMP1_RR_DIV_clock output : CMP1 */
#define BOARD_BOOTCLOCKPLL180M_CMP2_FUNC_DIV_CLOCK    0UL            /* Clock consumers of CMP2_FUNC_DIV_clock output : CMP2 */
#define BOARD_BOOTCLOCKPLL180M_CMP2_RR_DIV_CLOCK      0UL            /* Clock consumers of CMP2_RR_DIV_clock output : CMP2 */
#define BOARD_BOOTCLOCKPLL180M_CPU_CLOCK              180000000UL    /* Clock consumers of CPU_clock output : N/A */
#define BOARD_BOOTCLOCKPLL180M_CTIMER0_CLOCK          0UL            /* Clock consumers of CTIMER0_clock output : CTIMER0 */
#define BOARD_BOOTCLOCKPLL180M_CTIMER1_CLOCK          0UL            /* Clock consumers of CTIMER1_clock output : CTIMER1 */
#define BOARD_BOOTCLOCKPLL180M_CTIMER2_CLOCK          0UL            /* Clock consumers of CTIMER2_clock output : CTIMER2 */
#define BOARD_BOOTCLOCKPLL180M_CTIMER3_CLOCK          0UL            /* Clock consumers of CTIMER3_clock output : CTIMER3 */
#define BOARD_BOOTCLOCKPLL180M_CTIMER4_CLOCK          0UL            /* Clock consumers of CTIMER4_clock output : CTIMER4 */
#define BOARD_BOOTCLOCKPLL180M_DAC0_CLOCK             0UL            /* Clock consumers of DAC0_clock output : DAC0 */
#define BOARD_BOOTCLOCKPLL180M_FLEXCAN0_CLOCK         0UL            /* Clock consumers of FLEXCAN0_clock output : CAN0 */
#define BOARD_BOOTCLOCKPLL180M_FLEXCAN1_CLOCK         0UL            /* Clock consumers of FLEXCAN1_clock output : CAN1 */
#define BOARD_BOOTCLOCKPLL180M_FLEXIO0_CLOCK          0UL            /* Clock consumers of FLEXIO0_clock output : FLEXIO0 */
#define BOARD_BOOTCLOCKPLL180M_FREQME_REFERENCE_CLOCK 0UL            /* Clock consumers of FREQME_reference_clock output : N/A */
#define BOARD_BOOTCLOCKPLL180M_FREQME_TARGET_CLOCK    0UL            /* Clock consumers of FREQME_target_clock output : N/A */
#define BOARD_BOOTCLOCKPLL180M_FRO_12M_DIV_CLOCK      12000000UL     /* Clock consumers of FRO_12M_DIV_clock output : N/A */
#define BOARD_BOOTCLOCKPLL180M_FRO_12M_CLOCK          12000000UL     /* Clock consumers of FRO_12M_clock output : N/A */
#define BOARD_BOOTCLOCKPLL180M_FRO_HF_DIV_CLOCK       45000000UL     /* Clock consumers of FRO_HF_DIV_clock output : N/A */
#define BOARD_BOOTCLOCKPLL180M_FRO_HF_CLOCK           45000000UL     /* Clock consumers of FRO_HF_clock output : N/A */
#define BOARD_BOOTCLOCKPLL180M_I3C_FCLK_CLOCK         0UL            /* Clock consumers of I3C_FCLK_clock output : I3C0 */
#define BOARD_BOOTCLOCKPLL180M_I3C_SLOW_TC_CLOCK      0UL            /* Clock consumers of I3C_SLOW_TC_clock output : I3C0 */
#define BOARD_BOOTCLOCKPLL180M_I3C_SLOW_CLOCK         0UL            /* Clock consumers of I3C_SLOW_clock output : I3C0 */
#define BOARD_BOOTCLOCKPLL180M_LPI2C0_CLOCK           0UL            /* Clock consumers of LPI2C0_clock output : LPI2C0 */
#define BOARD_BOOTCLOCKPLL180M_LPI2C1_CLOCK           0UL            /* Clock consumers of LPI2C1_clock output : LPI2C1 */
#define BOARD_BOOTCLOCKPLL180M_LPI2C2_CLOCK           0UL            /* Clock consumers of LPI2C2_clock output : LPI2C2 */
#define BOARD_BOOTCLOCKPLL180M_LPI2C3_CLOCK           0UL            /* Clock consumers of LPI2C3_clock output : LPI2C3 */
#define BOARD_BOOTCLOCKPLL180M_LPSPI0_CLOCK           0UL            /* Clock consumers of LPSPI0_clock output : LPSPI0 */
#define BOARD_BOOTCLOCKPLL180M_LPSPI1_CLOCK           0UL            /* Clock consumers of LPSPI1_clock output : LPSPI1 */
#define BOARD_BOOTCLOCKPLL180M_LPTMR0_CLOCK           0UL            /* Clock consumers of LPTMR0_clock output : LPTMR0 */
#define BOARD_BOOTCLOCKPLL180M_LPUART0_CLOCK          0UL            /* Clock consumers of LPUART0_clock output : LPUART0 */
#define BOARD_BOOTCLOCKPLL180M_LPUART1_CLOCK          0UL            /* Clock consumers of LPUART1_clock output : LPUART1 */
#define BOARD_BOOTCLOCKPLL180M_LPUART2_CLOCK          0UL            /* Clock consumers of LPUART2_clock output : LPUART2 */
#define BOARD_BOOTCLOCKPLL180M_LPUART3_CLOCK          0UL            /* Clock consumers of LPUART3_clock output : LPUART3 */
#define BOARD_BOOTCLOCKPLL180M_LPUART4_CLOCK          0UL            /* Clock consumers of LPUART4_clock output : LPUART4 */
#define BOARD_BOOTCLOCKPLL180M_LPUART5_CLOCK          0UL            /* Clock consumers of LPUART5_clock output : LPUART5 */
#define BOARD_BOOTCLOCKPLL180M_MAIN_CLOCK             180000000UL    /* Clock consumers of MAIN_clock output : FLEXPWM0, FLEXPWM1 */
#define BOARD_BOOTCLOCKPLL180M_OSTIMER0_CLOCK         0UL            /* Clock consumers of OSTIMER0_clock output : OSTIMER0 */
#define BOARD_BOOTCLOCKPLL180M_PLL1_DIV_CLOCK         45000000UL     /* Clock consumers of PLL1_DIV_clock output : N/A */
#define BOARD_BOOTCLOCKPLL180M_PLL1_CLOCK             180000000UL    /* Clock consumers of PLL1_clock output : N/A */
#define BOARD_BOOTCLOCKPLL180M_SYSTICK_CLOCK          0UL            /* Clock consumers of SYSTICK_clock output : N/A */
#define BOARD_BOOTCLOCKPLL180M_SLOW_CLOCK             30000000UL     /* Clock consumers of Slow_clock output : AOI0, AOI1, CMC, LPTMR0, RTC0, SLCD0, WAKETIMER0 */
#define BOARD_BOOTCLOCKPLL180M_SYSTEM_CLOCK           180000000UL    /* Clock consumers of System_clock output : ADC0, ADC1, ADC2, ADC3, CAN0, CAN1, CMP0, CMP1, CMP2, CTIMER0, CTIMER1, CTIMER2, CTIMER3, CTIMER4, DAC0, DMA0, EQDC0, EQDC1, FLEXIO0, FLEXPWM0, FLEXPWM1, FREQME0, GPIO0, GPIO1, GPIO2, GPIO3, GPIO4, I3C0, LPI2C0, LPI2C1, LPI2C2, LPI2C3, LPSPI0, LPSPI1, LPUART0, LPUART1, LPUART2, LPUART3, LPUART4, LPUART5, OPAMP0, OPAMP1, OPAMP2, OPAMP3, OSTIMER0, PORT0, PORT1, PORT2, PORT3, PORT4, USB0, UTICK0, WWDT0 */
#define BOARD_BOOTCLOCKPLL180M_TRACE_CLOCK            90000000UL     /* Clock consumers of TRACE_clock output : N/A */
#define BOARD_BOOTCLOCKPLL180M_USB0_CLOCK             0UL            /* Clock consumers of USB0_clock output : USB0 */
#define BOARD_BOOTCLOCKPLL180M_UTICK0_CLOCK           1000000UL      /* Clock consumers of UTICK0_clock output : UTICK0 */
#define BOARD_BOOTCLOCKPLL180M_WWDT0_CLOCK            1000000UL      /* Clock consumers of WWDT0_clock output : WWDT0 */


/*******************************************************************************
 * API for BOARD_BootClockPLL180M configuration
 ******************************************************************************/
#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus*/

/*!
 * @brief This function executes configuration of clocks.
 *
 */
void BOARD_BootClockPLL180M(void);

#if defined(__cplusplus)
}
#endif /* __cplusplus*/

#endif /* _CLOCK_CONFIG_H_ */

